/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.recipe.stone_mill;

import cloud.lemonslice.teastory.blockentity.StoneMillBlockEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import xueluoanping.teastory.craft.BlockEntityRecipeWrapper;
import xueluoanping.teastory.craft.FluidIngredient;
import xueluoanping.teastory.registry.RecipeRegister;

public class StoneMillRecipe
implements Recipe<BlockEntityRecipeWrapper> {
    protected final ResourceLocation id;
    protected final String group;
    protected final FluidIngredient inputFluid;
    protected final Ingredient inputItem;
    protected final NonNullList<ItemStack> outputItems;
    protected final FluidStack outputFluid;
    protected final int workTime;

    public StoneMillRecipe(ResourceLocation idIn, String groupIn, Ingredient inputItem, FluidIngredient inputFluid, NonNullList<ItemStack> outputItems, FluidStack outputFluid, int workTime) {
        this.id = idIn;
        this.group = groupIn;
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputItems = outputItems;
        this.outputFluid = outputFluid;
        this.workTime = workTime;
    }

    public boolean matches(BlockEntityRecipeWrapper inv, Level worldIn) {
        BlockEntity blockEntity;
        if (this.inputItem.test(inv.m_8020_(0)) && (blockEntity = inv.getBlockEntity()) instanceof StoneMillBlockEntity) {
            StoneMillBlockEntity stoneMillTileEntity = (StoneMillBlockEntity)blockEntity;
            boolean match = this.getOutputFluid().isEmpty() || stoneMillTileEntity.getFluidTank().fill(this.getOutputFluid(), IFluidHandler.FluidAction.SIMULATE) == this.getOutputFluid().getAmount();
            return match |= this.getInputFluid().getRequiredAmount() == 0 || stoneMillTileEntity.getInputFluidTank().drain(this.getInputFluidStack(), IFluidHandler.FluidAction.SIMULATE).getAmount() == this.getInputFluid().getRequiredAmount();
        }
        return false;
    }

    public ItemStack assemble(BlockEntityRecipeWrapper p_44001_, RegistryAccess p_267165_) {
        return !this.outputItems.isEmpty() ? ((ItemStack)this.outputItems.get(0)).m_41777_() : ItemStack.f_41583_.m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return !this.outputItems.isEmpty() ? (ItemStack)this.outputItems.get(0) : ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.getInputItem()});
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public FluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    public NonNullList<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public int getWorkTime() {
        return this.workTime;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegister.STONE_MILL_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegister.STONE_MILL.get();
    }

    public FluidStack getInputFluidStack() {
        return !this.inputFluid.getMatchingFluidStacks().isEmpty() ? this.inputFluid.getMatchingFluidStacks().get(0) : FluidStack.EMPTY;
    }

    public static class StoneMillRecipeSerializer
    extends NewRegistryEvent
    implements RecipeSerializer<StoneMillRecipe> {
        private static NonNullList<ItemStack> readItems(JsonArray array) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                JsonElement item = array.get(i);
                ItemStack itemStack = item.isJsonObject() ? ShapedRecipe.m_151274_((JsonObject)((JsonObject)item)) : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(((JsonObject)item).get("output_items").getAsString())));
                nonnulllist.add((Object)itemStack);
            }
            return nonnulllist;
        }

        public StoneMillRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            FluidStack outputFluid;
            String group;
            String string = group = json.has("group") ? json.get("group").getAsString() : "";
            if (!json.has("item_ingredient")) {
                throw new JsonSyntaxException("Missing input ingredient, expected to find a string or object");
            }
            Ingredient inputItem = Ingredient.m_43917_((JsonElement)json.get("item_ingredient"));
            FluidIngredient inputFluid = json.has("fluid_ingredient") ? FluidIngredient.deserialize(json.get("fluid_ingredient")) : FluidIngredient.EMPTY;
            if (!json.has("output_fluid") && !json.has("output_items")) {
                throw new JsonSyntaxException("Missing output, expected to find a string or object");
            }
            if (json.has("output_fluid")) {
                JsonObject jsonOutputFluid = json.getAsJsonObject("output_fluid");
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jsonOutputFluid.get("fluid").getAsString()));
                if (fluid == null) {
                    outputFluid = FluidStack.EMPTY;
                } else {
                    int amount = jsonOutputFluid.get("amount").getAsInt();
                    outputFluid = new FluidStack(fluid, amount);
                }
            } else {
                outputFluid = FluidStack.EMPTY;
            }
            NonNullList<ItemStack> outputItems = json.has("output_items") ? StoneMillRecipeSerializer.readItems(json.getAsJsonArray("output_items")) : NonNullList.m_122779_();
            int i = json.has("work_time") ? json.get("work_time").getAsInt() : 200;
            return new StoneMillRecipe(recipeId, group, inputItem, inputFluid, outputItems, outputFluid, i);
        }

        public StoneMillRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String groupIn = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient inputItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidIngredient inputFluid = FluidIngredient.read(buffer);
            int i = buffer.m_130242_();
            NonNullList outputItems = NonNullList.m_122780_((int)i, (Object)ItemStack.f_41583_);
            for (int j = 0; j < i; ++j) {
                outputItems.set(j, (Object)buffer.m_130267_());
            }
            FluidStack outputFluid = buffer.readFluidStack();
            int workTime = buffer.m_130242_();
            return new StoneMillRecipe(recipeId, groupIn, inputItem, inputFluid, (NonNullList<ItemStack>)outputItems, outputFluid, i);
        }

        public void toNetwork(FriendlyByteBuf buffer, StoneMillRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            recipe.getInputItem().m_43923_(buffer);
            recipe.getInputFluid().write(buffer);
            buffer.m_130130_(recipe.getOutputItems().size());
            for (ItemStack ingredient : recipe.getOutputItems()) {
                buffer.writeItemStack(ingredient, false);
            }
            FluidIngredient fluidIngredient = FluidIngredient.EMPTY;
            buffer.writeFluidStack(recipe.getOutputFluid());
            buffer.m_130130_(recipe.getWorkTime());
        }
    }
}

